# Present‑Act V2 — Phase‑Noise (Pure Dephasing) Benchmark

This repository reproduces the dephasing benchmark you requested, implemented in the V2 present‑act framing with boolean acceptance (no structural gradients), CRA on (diagnostics‑side check for non‑common‑mode), and a diagnostics‑only interferometer readout.

**What it measures**  
Fringe visibility attenuation vs timing jitter and validation of the analytic attenuation factors (characteristic functions). Default windows are centered at 0 and 0.5 cycles with half‑width ε = 0.10. Bias readout set at δt=0.

**Jitter families & predictions**
- Uniform: η ~ Unif[−J,J], J ∈ {0, 0.02, …, 0.25} → pred(J) = sin(2πJ)/(2πJ)
- Gaussian: η ~ 𝒩(0,σ²), σ ∈ {0.02, …, 0.20} → pred(σ) = exp(−2π²σ²)
- Two‑point: η ∈ {±a} (p=0.5), a ∈ {0.02, …, 0.20} → pred(a) = cos(2πa)

**Outputs (default K = 50,000 per point)**
- `artifacts/dephasing_uniform.csv` → columns: `J, visibility, visibility_norm, pred_sinc, ratio, neutral_rate, cra_consistency_flag`
- `artifacts/dephasing_gaussian.csv` → `sigma, visibility_norm, pred_exp, ratio`
- `artifacts/dephasing_twopoint.csv` → `a, visibility_norm, pred_cos, ratio`
- `artifacts/summary.json` → RMSEs and pass/fail; uniform also checked for monotone decrease
- `artifacts/uniform_fit.png` → overlay of measured vs prediction

The design preserves **control/diagnostics separation**: acceptance is boolean/equality‑based; interferometer windows, jitter, and the characteristic‑function estimator live **only** in diagnostics and never steer acceptance. CRA is enabled as a diagnostics‑side anti‑common‑mode check in this benchmark (non‑overlapping windows imply CRA passes). See the V2 contract for the pins and separation. 

> V2.1 control contract and separation of concerns are detailed in the provided theory document (cited in the accompanying correspondence).

---

## Quick start

```bash
python3 -m venv .venv && source .venv/bin/activate
pip install -r requirements.txt

# Reproduce the full benchmark (uniform + gaussian + two-point)
python run.py --outdir artifacts

# Uniform only
python run.py --uniform --outdir artifacts

# Change trials per point (default 50000)
python run.py --k 50000 --outdir artifacts
```

Artifacts will be written into the chosen `--outdir` (default: `artifacts/`).

---

## CLI

```
usage: run.py [-h] [--outdir OUTDIR] [--k K] [--seed SEED]
              [--eps-window EPS_WINDOW] [--centers 0.0 0.5]
              [--uniform] [--gaussian] [--twopoint] [--no-plot]
```

- `--outdir`: directory for CSV/JSON/PNG outputs (default: `artifacts/`)
- `--k`: trials per jitter point (default: 50000)
- `--seed`: base RNG seed (default: 20251031)
- `--eps-window`: half‑width of windows in cycles (default: 0.10)
- `--centers`: two window centers in cycles (default: 0.0 0.5)
- Flags `--uniform`, `--gaussian`, `--twopoint` select which suites to run (by default all three).  
- `--no-plot`: skip the uniform overlay figure

---

## What this implements (V2 framing)

- **Acceptance**: boolean gates + equality fit on a finite alphabet; no weights in control.
- **CRA**: enabled as an anti‑common‑mode guard; with non‑overlapping windows, it is stable.
- **Diagnostics only**: interferometer windows, jitter, and the characteristic‑function estimator `E[cos(2π η)]` (the normalized visibility that matches the analytic attenuation).
- **Determinism**: PCG64 RNG seeded (default `20251031`); only sampling occurs in diagnostics draws of jitter; acceptance remains deterministic.

The overall structure aligns with the V2 pins (local decisions, boolean feasibility, equality fit, PF/Born ties‑only if needed, control/diagnostics separation). For this benchmark, ties never occur because windows are non‑overlapping.

---

## Reproducibility note

Using the defaults (K=50k, seed=20251031), you should see RMSEs roughly:

- Uniform sinc: ~4e-4 (PASS), monotone decreasing
- Gaussian exp: ~1.8e-3 (PASS)
- Two‑point cos: numerical‑zero error (≈1e‑16, PASS)

These match the run shown in `artifacts/summary.json` after you execute `run.py` once.

---

## License

MIT (see `LICENSE`).

